/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Type;
import com.kenai.jaffl.provider.MemoryManager;
import com.kenai.jaffl.provider.NativeType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FFIProvider {
    public static final FFIProvider getProvider() {
        return SingletonHolder.INSTANCE;
    }

    public abstract MemoryManager getMemoryManager();

    public abstract <T> T loadLibrary(String var1, Class<T> var2, Map<LibraryOption, ?> var3);

    public abstract <T> T loadLibrary(Class<T> var1, Map<LibraryOption, ?> var2, String ... var3);

    public abstract int getLastError();

    public abstract void setLastError(int var1);

    public abstract Type getType(NativeType var1);

    protected FFIProvider() {
    }

    private static final class SingletonHolder {
        private static final FFIProvider INSTANCE = SingletonHolder.getInstance();

        private SingletonHolder() {
        }

        private static final FFIProvider getInstance() {
            boolean bl = Boolean.getBoolean("jaffl.usejna");
            FFIProvider fFIProvider = null;
            String string = FFIProvider.class.getPackage().getName() + ".provider";
            if (!bl) {
                try {
                    fFIProvider = (FFIProvider)Class.forName(string + ".jffi.Provider").newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (fFIProvider == null) {
                try {
                    fFIProvider = (FFIProvider)Class.forName(string + ".jna.JNAProvider").newInstance();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Could not load FFI provider", throwable);
                }
            }
            return fFIProvider;
        }
    }
}

